$(function(){
    var i18nConfig = {
        "ja" : {
            "detail_texts__title":                          "HTMLブロック",

            "environment__title":                           "動作確認環境",
            "environment_left_content__title_0":            "HTML5 Viewer",
            "environment_left_content__title_1":            "OS及びブラウザ",
            "environment_left_content__text_1_1":           "Windows",
            "environment_left_content__text_1_2":           "Microsoft Edge (Chromium) 最新版 / Google Chrome 最新版",
            "environment_left_content__text_2_1":           "iOS 最新版 (18.0)",
            "environment_left_content__text_2_2":           "Safari 最新版",
            "environment_left_content__text_3_1":           "Android 14.0以上、15.0未満",
            "environment_left_content__text_3_2":           "Google Chrome 最新版",
            "environment_left_content__other_1":            "（一部機種は正常に動作しない場合があります）",
            "environment_left_content__title_2":            "アプリ推奨環境",
            "environment_left_content__title_3":            "動作確認端末",
            "environment_left_content__text_4":             "各アプリストアの詳細説明 をご覧ください。",
            "environment_left_content__text_5_1":           "macOS",
            "environment_left_content__text_5_2":           "Safari 最新版",


            "environment_right_content__icon_1":            "※",
            "environment_right_content__text_1":            "Apple、Apple のロゴ、mac OS は、米国および他の国々で登録されたApple Inc.の商標です。",
            "environment_right_content__text_2":            "※iOSは，Apple Inc.のOS名称です。IOSは，Cisco Systems, Inc.またはその関連会社の米国およびその他の国における登録商標または商標であり，ライセンスに基づき使用されています。",
            "environment_right_content__text_3":            "Google および Android、Google Chrome、Google Play は、米国および他の国々で登録されたGoogle Inc.の商標又は登録商標です。",
            "environment_right_content__text_4":            "Microsoft、Windows、Windows 10 またはその他のマイクロソフト製品の名称および製品名は、米国Microsoft Corporationの米国およびその他の国における商標または登録商標です。",


            "index__head__title":                           $.title,

            "pc__detail_block__share__title":               "シェア",
            "pc__detail_block__normal__title":              "通常",
            "pc__detail_block__larger__title":              "拡大",
            "pc__detail_block__zoomin__title":              "全画面",
            "pc__detail_block__app_button__title":          "Posteで開く",
            "pc__detail_block__print__title":               "印刷",

            "sd__detail_block__share__title":               "シェア",
            "sd__detail_block__app_button__text":           "Posteで開く",

            "sd__rotate_alert__message__text_1":            "本サイトは横表示に対応しておりません。",
            "sd__rotate_alert__message__text_2":            "縦表示でご覧ください。",
            "sd__rotate_alert__app_button__text_2":         "Posteアプリで開く",
            "sd__rotate_alert__message__text_3":            "ブックを横表示でご覧になりたい場合は、Posteアプリでご覧ください。",

        },
        "en" : {
            "detail_texts__title":                          "HTML block",

            "environment__title":                           "Working Environment",

            "environment_left_content__title_0":            "HTML5 Viewer",
            "environment_left_content__title_1":            "OS and Browser",
            "environment_left_content__text_1_1":           "Windows",
            "environment_left_content__text_1_2":           "Latest Microsoft Edge (Chromium) / Latest Google Chrome",
            "environment_left_content__text_2_1":           "Latest iOS (18.0)",
            "environment_left_content__text_2_2":           "Latest Safari",
            "environment_left_content__text_3_1":           "Android 14.0 and above, Below 15.0",
            "environment_left_content__text_3_2":           "Google Chrome latest version",
            "environment_left_content__other_1":            "(On some terminals might not work properly)",
            "environment_left_content__title_2":            "App recommended environment",
            "environment_left_content__title_3":            "Working Terminals",
            "environment_left_content__text_4":             "Please see the explanation detail in each app store.",
            "environment_left_content__text_5_1":           "macOS",
            "environment_left_content__text_5_2":           "Latest Safari",

            "environment_right_content__icon_1":            "※",
            "environment_right_content__text_1":            "Apple, the Apple logo and mac OS are trademarks of Apple Inc., registered in the US and other countries.",
            "environment_right_content__text_2":            "※iOS is the OS name of Apple Inc. IOS is a registered trademark or trademark of Cisco Systems, Inc. or its affiliates in the United States and other countries and is used under license.",
            "environment_right_content__text_3":            "Google and Android, Google Chrome, Google Play are trademarks or registered trademarks of Google Inc., registered in the US and other countries.",
            "environment_right_content__text_4":            "Microsoft, Windows, Windows 10 and other Microsoft product names and product names are trademarks or registered trademarks of Microsoft Corporation in the US and other countries.",

            "index__head__title":                           $.title,

            "pc__detail_block__share__title":               "Share",
            "pc__detail_block__normal__title":              "Normal",
            "pc__detail_block__larger__title":              "Enlarge",
            "pc__detail_block__zoomin__title":              "Fullscreen",
            "pc__detail_block__app_button__title":          "Poste",
            "pc__detail_block__print__title":               "Printing",

            "sd__detail_block__share__title":               "Share",
            "sd__detail_block__app_button__text":           "Poste",

            "sd__rotate_alert__message__text_1":            "This site does not support landscape display.",
            "sd__rotate_alert__message__text_2":            "Please view with portrait display.",
            "sd__rotate_alert__app_button__text_2":         "Open in Poste",
            "sd__rotate_alert__message__text_3":            "If you would like to view the content with landscape,please use Poste App.",

        },
        "cn" : {
            "detail_texts__title":                          "HTML块",

            "environment__title":                           "操作确认环境",

            "environment_left_content__title_0":            "HTML5网页",
            "environment_left_content__title_1":            "OS和浏览器",
            "environment_left_content__text_1_1":           "Windows",
            "environment_left_content__text_1_2":           "Microsoft Edge (Chromium) 最新版 / Google Chrome 最新版",
            "environment_left_content__text_2_1":           "iOS 最新版 (18.0)",
            "environment_left_content__text_2_2":           "Safari 最新版",
            "environment_left_content__text_3_1":           "Android 14.0或更高版本，低于15.0",
            "environment_left_content__text_3_2":           "Google Chrome 最新版",
            "environment_left_content__other_1":            "（某些设备型号可能无法正常工作）",
            "environment_left_content__title_2":            "App推荐的环境",
            "environment_left_content__title_3":            "操作确认终端",
            "environment_left_content__text_4":             "请参阅每个应用商店的详细说明。",
            "environment_left_content__text_5_1":           "macOS",
            "environment_left_content__text_5_2":           "Safari 最新版",

            "environment_right_content__icon_1":            "※",
            "environment_right_content__text_1":            "Apple，Apple标识和mac OS属于在美国和其他国家地区注册的Apple股份有限公司的商标。",
            "environment_right_content__text_2":            "※iOS是Apple股份有限公司的OS名称。 IOS是Cisco Systems股份有限公司或其附属公司在美国及其他国家地区的注册商标或商标，并经许可使用。",
            "environment_right_content__text_3":            "Google和Android，Google Chrome，Google Play是股份有限公司在美国和其他国家地区注册的商标或注册商标。",
            "environment_right_content__text_4":            "Microsoft，Windows，Windows10和其他Microsoft产品名称和产品名是微软公司在美国和其他国家地区的商标或注册商标。",

            "index__head__title":                           $.title,

            "pc__detail_block__share__title":               "分享",
            "pc__detail_block__normal__title":              "普通",
            "pc__detail_block__larger__title":              "扩大",
            "pc__detail_block__zoomin__title":              "全屏",
            "pc__detail_block__app_button__title":          "用Poste打开",
            "pc__detail_block__print__title":               "打印",

            "sd__detail_block__share__title":               "分享",
            "sd__detail_block__app_button__text":           "用Poste打开",

            "sd__rotate_alert__message__text_1":            "此网站不支持水平显示。",
            "sd__rotate_alert__message__text_2":            "请用竖屏查看。",
            "sd__rotate_alert__app_button__text_2":         "用Poste App打开",
            "sd__rotate_alert__message__text_3":            "如果您想横屏查看该内容，请使用Poste App。",

        },
        "tw" : {
            "detail_texts__title":                          "HTML塊",

            "environment__title":                           "操作確認環境",

            "environment_left_content__title_0":            "HTML5網頁",
            "environment_left_content__title_1":            "OS和瀏覽器",
            "environment_left_content__text_1_1":           "Windows",
            "environment_left_content__text_1_2":           "Microsoft Edge (Chromium) 最新版 / Google Chrome 最新版",
            "environment_left_content__text_2_1":           "iOS 最新版 (18.0)",
            "environment_left_content__text_2_2":           "Safari 最新版",
            "environment_left_content__text_3_1":           "Android 14.0或更高版本，低於15.0",
            "environment_left_content__text_3_2":           "Google Chrome 最新版",
            "environment_left_content__other_1":            "（某些設備型號可能無法正常工作）",
            "environment_left_content__title_2":            "App推薦的環境",
            "environment_left_content__title_3":            "操作確認終端",
            "environment_left_content__text_4":             "請參閱每個應用商店的詳細說明。",
            "environment_left_content__text_5_1":           "macOS",
            "environment_left_content__text_5_2":           "Safari 最新版",

            "environment_right_content__icon_1":            "※",
            "environment_right_content__text_1":            "Apple，Apple標識和mac OS屬於在美國和其他國家地區註冊的Apple股份有限公司的商標。",
            "environment_right_content__text_2":            "※iOS是Apple股份有限公司的OS名稱。 IOS是Cisco Systems股份有限公司或其附屬公司在美國及其他國家地區的註冊商標或商標，並經許可使用。",
            "environment_right_content__text_3":            "Google和Android，Google Chrome，Google Play是股份有限公司在美國和其他國家地區註冊的商標或註冊商標。",
            "environment_right_content__text_4":            "Microsoft，Windows，Windows10和其他Microsoft產品名稱和產品名是微軟公司在美國和其他國家地區的商標或註冊商標。",

            "index__head__title":                           $.title,

            "pc__detail_block__share__title":               "分享",
            "pc__detail_block__normal__title":              "普通",
            "pc__detail_block__larger__title":              "擴大",
            "pc__detail_block__zoomin__title":              "全屏",
            "pc__detail_block__app_button__title":          "用Poste打開",
            "pc__detail_block__print__title":               "打印",

            "sd__detail_block__share__title":               "分享",
            "sd__detail_block__app_button__text":           "用Poste打開",

            "sd__rotate_alert__message__text_1":            "此網站不支持水平顯示。",
            "sd__rotate_alert__message__text_2":            "請用豎屏查看。",
            "sd__rotate_alert__app_button__text_2":         "用Poste App打開",
            "sd__rotate_alert__message__text_3":            "如果您想橫屏查看該內容，請使用Poste App。",

        }
    };

    // 0.初始化国际化语言.
    // 1:ja  2:en(Default) 3:cn 4:tw
    var i18nText = i18nConfig["en"];

    var _params = getParams();
    if(_params["dispLanguage"] == "1"){
        i18nText = i18nConfig["ja"];
    }else if(_params["dispLanguage"] == "2"){
        i18nText = i18nConfig["en"];
    }else if(_params["dispLanguage"] == "3"){
        i18nText = i18nConfig["cn"];
    }else if(_params["dispLanguage"] == "4"){
        i18nText = i18nConfig["tw"];
    }else{

    }

    var i18n = {
        "detail_texts__title":                          i18nText["detail_texts__title"],

        "environment__title":                           i18nText["environment__title"],
        "environment_left_content__title_0":            i18nText["environment_left_content__title_0"],
        "environment_left_content__title_1":            i18nText["environment_left_content__title_1"],
        "environment_left_content__text_1":             i18nText["environment_left_content__text_1_1"] + "<br>" + i18nText["environment_left_content__text_1_2"],
        "environment_left_content__text_2":             i18nText["environment_left_content__text_2_1"] + "<br>" + i18nText["environment_left_content__text_2_2"],
        "environment_left_content__text_3":             i18nText["environment_left_content__text_3_1"] + "<br>" + i18nText["environment_left_content__text_3_2"],
        "environment_left_content__other_1":            i18nText["environment_left_content__other_1"],
        "environment_left_content__title_2":            i18nText["environment_left_content__title_2"],
        "environment_left_content__title_3":            i18nText["environment_left_content__title_3"],
        "environment_left_content__text_4":             i18nText["environment_left_content__text_4"],
        "environment_left_content__text_5":             i18nText["environment_left_content__text_5_1"] + "<br>" + i18nText["environment_left_content__text_5_2"],

        "environment_right_content__text_1":            i18nText["environment_right_content__icon_1"] + i18nText["environment_right_content__text_1"]
                                                            + "<br>" + i18nText["environment_right_content__text_2"]
                                                            + "<br><br>" + i18nText["environment_right_content__icon_1"] + i18nText["environment_right_content__text_3"]
                                                            + "<br><br>" + i18nText["environment_right_content__icon_1"] + i18nText["environment_right_content__text_4"],

        "index__head__title":                           i18nText["index__head__title"],

        "pc__detail_block__share__title":               i18nText["pc__detail_block__share__title"],
        "pc__detail_block__normal__title":              i18nText["pc__detail_block__normal__title"],
        "pc__detail_block__larger__title":              i18nText["pc__detail_block__larger__title"],
        "pc__detail_block__zoomin__title":              i18nText["pc__detail_block__zoomin__title"],
        "pc__detail_block__app_button__title":          i18nText["pc__detail_block__app_button__title"],
        "pc__detail_block__print__title":               i18nText["pc__detail_block__print__title"],

        "sd__detail_block__share__title":               i18nText["sd__detail_block__share__title"],
        "sd__detail_block__app_button__text":           i18nText["sd__detail_block__app_button__text"],

        "sd__rotate_alert__message__text_1":            i18nText["sd__rotate_alert__message__text_1"]
                                                            + "<br>" + i18nText["sd__rotate_alert__message__text_2"],
        "sd__rotate_alert__app_button__text_2":         i18nText["sd__rotate_alert__app_button__text_2"],
        "sd__rotate_alert__message__text_3":            i18nText["sd__rotate_alert__message__text_3"],

    }

    /* initText */
    $("[data-text]").each(function() {
        var _text = $(this).attr("data-text");
        $(this).append(i18n[_text] || "");

        $(this).removeAttr("data-text");
    });

});
